/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Dimension;
import java.awt.Graphics;
import jclass.chart.AxisHandler;
import jclass.chart.ErrorDialog;
import jclass.chart.JCAxis;
import jclass.chart.JCChartUtil;

class LogAxisHandler
extends AxisHandler {
    LogAxisHandler(JCAxis jCAxis) {
        super(jCAxis);
    }

    double toData(int n) {
        if (this.parent.isVertical) {
            n = this.parent.getHeight() - n;
        }
        return Math.pow(10.0, ((double)n - this.shift) / this.scale);
    }

    int toPixel(double d) {
        if (d <= 0.0) {
            d = this.parent.min.value;
        }
        int n = JCChartUtil.ifloor(this.scale * JCChartUtil.log10(d) + this.shift + 0.5);
        if (this.parent.isVertical) {
            return this.parent.getHeight() - n;
        }
        return n;
    }

    void calcParams() {
        double d = this.parent.dataLimits == null ? 1.0 : this.parent.dataLimits.min;
        double d2 = this.parent.dataLimits == null ? 100.0 : this.parent.dataLimits.max;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        d = this.parent.min.isDefault ? d : this.parent.min.value;
        d2 = this.parent.max.isDefault ? d2 : this.parent.max.value;
        n = JCChartUtil.ifloor(JCChartUtil.log10(d));
        n2 = JCChartUtil.iceil(JCChartUtil.log10(d2));
        if (this.parent.isVertical) {
            if (this.parent.origin.isDefault || this.parent.origin.value <= 0.0) {
                if (this.parent.chartType == 9 || this.parent.chartType == 10 || this.parent.chartType == 8) {
                    --n;
                }
            } else if (!this.parent.origin.isDefault && this.parent.origin.value > 0.0) {
                n5 = JCChartUtil.ifloor(JCChartUtil.log10(this.parent.origin.value));
                if (n5 < n && this.parent.min.isDefault) {
                    n = n5;
                }
                if (n5 > n2 && this.parent.max.isDefault) {
                    n2 = n5;
                }
            }
        } else if (!this.parent.origin.isDefault && this.parent.origin.value > 0.0) {
            n5 = JCChartUtil.ifloor(JCChartUtil.log10(this.parent.origin.value));
            if (n5 < n && this.parent.min.isDefault) {
                n = n5;
            }
            if (n5 > n2 && this.parent.max.isDefault) {
                n2 = n5;
            }
        }
        int n7 = 0;
        Dimension dimension = new Dimension();
        n6 = 1;
        while (n6 <= 5) {
            n3 = n;
            n4 = n2;
            boolean bl = JCChartUtil.abs(n4) > JCChartUtil.abs(n3);
            while ((n4 - n3) % n6 != 0) {
                if (bl) {
                    ++n4;
                } else {
                    --n3;
                }
                boolean bl2 = bl = !bl;
            }
            this.getAnnoExtent(dimension, n4, this.parent.precision.value);
            this.getAnnoExtent(dimension, n3, this.parent.precision.value);
            if (this.parent.isVertical) {
                n7 = this.parent.annotationRotation == 0 ? dimension.height * 2 : dimension.width + dimension.width / 2;
            } else {
                int n8 = n7 = this.parent.annotationRotation == 0 ? dimension.width + dimension.width / 2 : dimension.height * 2;
            }
            if ((n4 - n3) / n6 * n7 < this.parent.pixelLength()) break;
            ++n6;
        }
        if (n6 <= 5) {
            this.parent.logIncrement = n6;
        } else {
            n3 = n;
            n4 = n2;
            this.parent.logIncrement = Math.max(n4 - n3, 1);
        }
        if (this.parent.min.isDefault) {
            this.parent.min.value = JCChartUtil.pow10(n3);
        }
        if (this.parent.max.isDefault) {
            this.parent.max.value = JCChartUtil.pow10(n4);
        }
        if (this.parent.isVertical && (this.parent.chartType == 2 || this.parent.chartType == 3 || this.parent.chartType == 4)) {
            this.parent.origin.value = this.parent.max.value;
        } else if (this.parent.origin.isDefault || this.parent.origin.value <= 0.0) {
            switch (this.parent.originPlacement.value) {
                case 2: {
                    this.parent.origin.value = this.parent.max.value;
                    break;
                }
                case 0: 
                case 1: 
                case 3: {
                    this.parent.origin.value = this.parent.min.value;
                    break;
                }
            }
        }
        if (this.parent.isVertical) {
            this.parent.resize(n7 + 1 + this.parent.tickLength / 2, this.parent.getHeight());
            return;
        }
        this.parent.resize(this.parent.getWidth(), dimension.height + 1 + this.parent.tickLength / 2);
    }

    void calcTransformation() {
        int n = this.parent.pixelLength();
        int n2 = this.parent.pixelStart();
        double d = JCChartUtil.log10(this.parent.min.value);
        double d2 = JCChartUtil.log10(this.parent.max.value);
        double d3 = JCChartUtil.calcError(this.parent.precision.value);
        if (this.parent.isReversed) {
            n = -n;
        }
        if (Math.abs(d2 - d) < d3) {
            this.scale = 1.0;
            this.shift = 0.0;
            return;
        }
        this.scale = (double)n / (d2 - d);
        if (n < 0) {
            this.shift = (double)n2 - d2 * this.scale;
            return;
        }
        this.shift = (double)n2 - d * this.scale;
    }

    boolean fixBounds() {
        String string;
        boolean bl = super.fixBounds();
        if (!this.parent.max.isDefault && this.parent.max.value <= 0.0) {
            string = "Max must be positive for log axis.[NEWLINE]";
            string = String.valueOf(string) + "Setting MaxIsDefault to true.";
            ErrorDialog.raise(string);
            this.parent.max.isDefault = true;
            bl = true;
        }
        if (!this.parent.min.isDefault && this.parent.min.value <= 0.0) {
            string = "Min must be positive for log axis.";
            string = String.valueOf(string) + "Setting MinIsDefault to true.";
            ErrorDialog.raise(string);
            this.parent.min.isDefault = true;
            bl = true;
        }
        if (!this.parent.min.isDefault && !this.parent.max.isDefault) {
            double d = JCChartUtil.log10(this.parent.min.value);
            double d2 = JCChartUtil.log10(this.parent.max.value);
            if (d2 - d < Double.MIN_VALUE) {
                string = "Axis range is to small.";
                string = String.valueOf(string) + "Setting MaxIsDefault to true";
                ErrorDialog.raise(string);
                this.parent.max.isDefault = true;
                bl = true;
            }
        }
        return bl;
    }

    void drawTicks(Graphics graphics) {
        if (this.parent.annotationMethod != 0 && this.parent.tickSpacing.isDefault) {
            super.drawTicks(graphics);
            return;
        }
        int n = this.parent.linePosition();
        double d = this.parent.max.value;
        double d2 = this.parent.min.value;
        if (d <= 0.0) {
            d = 1.0;
            d2 = 0.1;
        } else {
            d2 = this.parent.min.value > 0.0 ? this.parent.min.value : d / 10.0;
        }
        int n2 = JCChartUtil.ifloor(JCChartUtil.log10(d2));
        int n3 = JCChartUtil.iceil(JCChartUtil.log10(d));
        int n4 = n2;
        while (n4 <= n3) {
            double d3 = JCChartUtil.pow10(n4);
            int n5 = 1;
            while (n5 < 10) {
                double d4 = (double)n5 * d3;
                if (!(d4 < this.parent.min.value) && !(d4 > this.parent.max.value)) {
                    int n6 = this.parent.toPixel(d4);
                    this.drawTick(graphics, n, n6);
                }
                ++n5;
            }
            ++n4;
        }
    }

    String format(double d, int n) {
        return JCChartUtil.logFormat((int)d);
    }

    double range() {
        int n = JCChartUtil.ifloor(JCChartUtil.log10(this.parent.min.value));
        int n2 = JCChartUtil.iceil(JCChartUtil.log10(this.parent.max.value));
        return n2 - n;
    }

    void translate(double d) {
        double d2 = JCChartUtil.log10(this.parent.min.value);
        double d3 = JCChartUtil.log10(this.parent.max.value);
        if (this.parent.isReversed) {
            d = -d;
        }
        this.parent.min.value = Math.pow(10.0, d2 + d);
        this.parent.max.value = Math.pow(10.0, d3 + d);
    }
}

